<?php $__env->startSection('title','Admin | Dashboard'); ?>

<?php $__env->startSection('main-body'); ?>
    <!-- Start page title -->
    <div class="qz-page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(__('Dashboard')); ?></h2>
                        <span class="sidebarToggler">
                            <i class="fa fa-bars d-lg-none d-block"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End page title -->

    <!-- Start content area  -->
    <div class="qz-content-area">
        <div class="card">
            <div class="card-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/total_user.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($totalUser); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Total User')); ?></h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/portfolio.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($totalProject); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Total Portfolio')); ?></h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/team.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($teams); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Team Members')); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/blog.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($posts); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Blog Posts')); ?></h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/services.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($services); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Services')); ?></h5>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 text-center">
                            <div class="qz-status-bar qz-status-bar-b">
                                <div class="das-img">
                                    <img src="<?php echo e(asset('assets/images/icon/pricing.svg')); ?>" alt="">
                                </div>
                                <div class="dash-text">
                                    <h4 class="qz-blance"><?php echo clean($plans); ?></h4>
                                    <h5 class="qz-total-qustions"><?php echo e(__('Pricing Plans')); ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="qz-sec-title">
                                        <h5><?php echo e(__('Monthly Blog Post Report')); ?></h5>
                                    </div>
                                    <p class="subtitle"><?php echo e(__('Current Year')); ?></p>
                                    <canvas id="mySalesChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-lg-12">
                            <div class="qz-sec-title">
                                <h5><?php echo e(__('Most Recent Blog Posts')); ?></h5>
                                <div class="table-responsive category-table">
                                    <table class="table category-table text-center rounded">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('SL.')); ?></th>
                                            <th><?php echo e(__('Image')); ?></th>
                                            <th><?php echo e(__('Post Title')); ?></th>
                                            <th><?php echo e(__('Comments')); ?></th>
                                            <th><?php echo e(__('Added On')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(isset($blogs[0])): ?>
                                            <?php ($sl = 1); ?>
                                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($sl++); ?></td>
                                                    <td class="table-image"><img src="<?php echo e($item->image); ?>" alt=""></td>
                                                    <td><?php echo clean(str_limit($item->title,80)); ?></td>
                                                    <td><?php echo clean(get_comments_count($item->id)); ?></td>
                                                    <td><?php echo clean(date('d M y', strtotime($item->created_at))); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="qz-table-footer">
                                            <td colspan=""></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td colspan=""><h5><a href="<?php echo e(route('blogList')); ?>"><?php echo e(__('View All')); ?></a></h5></td>
                                        </tr>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="5" class="text-center text-danger"><?php echo e(__('No data found')); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-lg-12">
                            <div class="qz-sec-title">
                                <h5><?php echo e(__('Recent Portfolios')); ?></h5>
                                <div class="table-responsive category-table">
                                    <table class="table category-table text-center rounded">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(__('SL.')); ?></th>
                                            <th><?php echo e(__('Image')); ?></th>
                                            <th><?php echo e(__('Title')); ?></th>
                                            <th><?php echo e(__('Category')); ?></th>
                                            <th><?php echo e(__('Added On')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(isset($portfolios[0])): ?>
                                            <?php ($sl = 1); ?>
                                            <?php $__currentLoopData = $portfolios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($sl++); ?></td>
                                                    <td class="table-image"><img src="<?php echo e($item->image[0]); ?>" alt=""></td>
                                                    <td><?php echo clean(str_limit($item->title,80)); ?></td>
                                                    <td><?php echo clean($item->category->name); ?></td>
                                                    <td><?php echo clean(date('d M y', strtotime($item->created_at))); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="qz-table-footer">
                                            <td colspan=""></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td colspan=""><h5><a href="<?php echo e(route('portfolioList')); ?>"><?php echo e(__('View All')); ?></a></h5></td>
                                        </tr>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="5" class="text-center text-danger"><?php echo e(__('No data found')); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End content area  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/js/revenue-chart.js')); ?>"></script>
    <script>
        var ctx = document.getElementById('mySalesChart').getContext("2d")
        var mySalesChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul","Aug", "Sep", "Oct", "Nov", "Dec"],
                datasets: [{
                    label: "Post",
                    backgroundColor: "#0EC64E",
                    borderColor: "#0EC64E",
                    pointBorderColor: "#0EC64E",
                    pointBackgroundColor: "#0EC64E",
                    pointHoverBackgroundColor: "#0EC64E",
                    pointHoverBorderColor: "#D1D1D1",
                    pointBorderWidth: 10,
                    pointHoverRadius: 10,
                    pointHoverBorderWidth: 1,
                    pointRadius: 3,
                    fill: true,
                    borderWidth: 1,
                    data: <?php echo json_encode($all_posts); ?>

                }]
            },
            options: {
                legend: {
                    position: "bottom",
                    display: true,
                    labels: {
                        fontColor: '#928F8F'
                    }
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            fontColor: "#928F8F",
                            fontStyle: "bold",
                            beginAtZero: true,
                            maxTicksLimit: 5,
                            padding: 20
                        },
                        gridLines: {
                            drawTicks: false,
                            display: false
                        }
                    }],
                    xAxes: [{
                        gridLines: {
                            zeroLineColor: "#f7788e"
                        },
                        ticks: {
                            padding: 20,
                            fontColor: "#928F8F",
                            fontStyle: "bold"
                        }
                    }]
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ayara/resources/views/admin/dashboard/dashboard.blade.php ENDPATH**/ ?>